
--[[ 
应用说明:访问BH1750前，请先调用一次 bsp_InitI2C()函数配置好I2C相关的GPIO.

光照度 lx
勒克斯 (Lux) 被光均匀照射的物体，距离该光源1米处，在1m2面积上得到的光通量是1lm时，它的照度是1lux

光照度可用照度计直接测量。光照度的单位是勒克斯，是英文lux的音译，也可写为lx。
被光均匀照射的物体，在1平方米面积上得到的光通量是1流明时，它的照度是1勒克斯。有时为了充分利用光源，
常在光源上附加一个反射装置，使得某些方向能够得到比较多的光通量，以增加这一被照面上的照度。例如
汽车前灯、手电筒、摄影灯等。

以下是各种环境照度值：单位lux
黑夜：0.001—0.02；
月夜：0.02—0.3；
阴天室内：5—50；
阴天室外：50—500；
晴天室内：100—1000；
夏季中午太阳光下的照度：约为10*9
阅读书刊时所需的照度：50—60；
家用摄像机标准照度：1400

BH1750FVI 为光照度测量芯片。测量量程可通过命令进行调节。
最小 0.11 lux， 最大 100000 lux
--]]

-------------I2C从机地址 -------------------------------------------

BH1750_SLAVE_ADDRESS = 0x46	

------------操作码 Opercode 定义--------------------------------------------
BHOP_POWER_DOWN = 0x00	--进入掉电模式。芯片上电后缺省就是PowerDown模式 
BHOP_POWER_ON = 0x01	-- 上电，等待测量命令
BHOP_RESET = 0x07		--清零数据寄存器 (Power Down 模式无效) 
BHOP_CON_H_RES  = 0x10	--连续高分辨率测量模式  （测量时间 120ms） （最大 180ms）
BHOP_CON_H_RES2 = 0x11	--连续高分辨率测量模式2 （测量时间 120ms）
BHOP_CON_L_RES = 0x13	--连续低分辨率测量模式 （测量时间 16ms）

BHOP_ONE_H_RES  = 0x20	-- 单次高分辨率测量模式 , 之后自动进入Power Down
BHOP_ONE_H_RES2 = 0x21	-- 单次高分辨率测量模式2 , 之后自动进入Power Down 
BHOP_ONE_L_RES = 0x23	-- 单次低分辨率测量模式 , 之后自动进入Power Down 

s_MTReg = 0 --灵敏度倍率
s_Mode = 0  --量模式

--向芯片发送1字节长度的操作码
--_ucOpecode 寄存器地址
function BH1750_WriteCmd(_ucOpecode)
    i2c_bus("start")
    i2c_bus("send", BH1750_SLAVE_ADDRESS) 
    i2c_bus("send", _ucOpecode) 
    i2c_bus("stop")
end

--修改BH1750测量模式，决定测量分辨率 
--__ucMode : 测量模式 值域(1，2，3)
function BH1750_ChageMode(_ucMode)
    -- 连续高分测量模式1
    if(_ucMode == 1)then
        BH1750_WriteCmd(BHOP_CON_H_RES);	
		s_Mode = 1;			 -- 测量模式1，分辨率 1 lux
    end

    -- 连续高分测量模式2
    if(_ucMode == 2)then
        BH1750_WriteCmd(BHOP_CON_H_RES2);	
		s_Mode = 2;			-- 测量模式2, 分辨率 0.5 lux
    end

    -- 连续高分测量模式3
    if(_ucMode == 3)then
        BH1750_WriteCmd(BHOP_CON_L_RES);	
		s_Mode = 3;			-- 测量模式3，低分辨率 4 lux
    end
end

--调节BH1750测量灵敏度
--ucMTReg : 量程倍率.  值域【31，254】，值越大 灵敏度越高
function BH1750_AdjustSensitivity(_ucMTReg)
    if(_ucMTReg <=31)then
        _ucMTReg = 31
    end

    if(_ucMTReg >=254)then
        _ucMTReg = 254
    end

    s_MTReg = _ucMTReg;

	BH1750_WriteCmd(0x40 + (s_MTReg >> 5));		-- 更改高3bit
	BH1750_WriteCmd(0x60 + (s_MTReg & 0x1F));	-- 更改低5bit
	
	--更改量程范围后，需要重新发送命令设置测量模式
	BH1750_ChageMode(s_Mode);
end

-- 读取BH1750测量结果.  主程序需要在 bsp_InitBH1750() 执行之后 180ms 才能读到正确数据
-- 连续测量模式下，之后主程序可以定时调用本函数读取光强度数据，间隔时间需要大于180ms
-- 返 回 值: 原始的测量数据 ,结果未转换
function BH1750_ReadData()

    local str
    local byte0, byte1
    local w

    i2c_bus("start")
    i2c_bus("send", BH1750_SLAVE_ADDRESS + 1) -- 读操作

    str = i2c_bus("recive", 2)

    byte0 = tonumber(string.byte(str,1,1))
    byte1 = tonumber(string.byte(str,2,2))

    w = byte0 * 256 + byte1
    i2c_bus("stop")

    return w
end

-- 读取BH1750测量结果, 并转换为 Lux单位
-- 光强度 [Lux]  浮点数
function BH1750_GetLux()

    local usLight
    local lux
    local lightstr

    usLight  = BH1750_ReadData()

    -- 计算光强度 = 16位寄存器值 / 1.2  * (69 / X) 
    -- lux = usLight * (((float)1 / 1.2) * ((float)69 / s_MTReg));
	lux = (usLight * 5 * 69) / (6 * s_MTReg);
	
	if (s_Mode == 2) then	-- 高分辨率测量模式2 
		lux = lux / 2;
	else
	   --  不必除2 
    end

    lightstr = string.format("读取BH1750光照传感器 = %f", lux)
    print(lightstr)

	return lux
end

function bsp_InitBH1750()

    BH1750_WriteCmd(BHOP_POWER_ON);	-- 芯片上电 

	BH1750_ChageMode(2);			-- 高分辨率连续测量 
	
	BH1750_AdjustSensitivity(69);	-- 芯片缺省灵敏度倍率 = 69 

end


----------------------------------------------------------------------
--  应用测试代码
-----------------------------------------------------------------------
bsp_InitBH1750() -- 初始化 

-- 连续获取30次并打印
for i = 1, 30, 1 do
    delayms(400)  -- 延迟要加上
    BH1750_GetLux()
end